﻿* Encoding: UTF-8.
*CARGAR BASE DE DATOS CASEN 2022*

GET
  FILE='C:\Users\catal\Desktop\Base de datos Casen 2022 SPSS_18 marzo 2024.sav'.
DATASET NAME ConjuntoDatos1 WINDOW=FRONT.

*APLICAMOS FILTRO PARA TRABAJAR SOLO CON PERSONAS DE LA REGION RM (13)*

DATASET ACTIVATE ConjuntoDatos1.
USE ALL.
COMPUTE filter_$=(region = 13).
VARIABLE LABELS filter_$ 'region = 13 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.
_SLINE OFF.

*GENERAMOS LA TABLA CRUZADA CON LAS VARIABLES H7F & S13*

CROSSTABS
  /TABLES=h7f BY s13
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT COLUMN 
  /COUNT ROUND CELL.
OUTPUT MODIFY
  /SELECT TABLES
  /IF COMMANDS=["Crosstabs(LAST)"] SUBTYPES=["Crosstabulation"]
  /TABLE PIVOT=[R1,C1].
OUTPUT MODIFY
  /SELECT TABLES
  /IF COMMANDS=["Crosstabs(LAST)"] SUBTYPES=["Crosstabulation"]
  /TABLECELLS SELECT=[PERCENT] APPLYTO=COLUMNHEADER REPLACE="%"
  /TABLECELLS SELECT=[COUNT] APPLYTO=COLUMNHEADER REPLACE="N".

*AGREGAMOS FILTRO DE AREA CON EL OPERADOR LOGICO "AND" PARA TRABAJAR CON PERSONAS DE LA RM DE ZONA RURAL*

USE ALL.
COMPUTE filter_$=(region = 13 AND area = 2).
VARIABLE LABELS filter_$ 'region = 13 AND area = 2 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.
_SLINE OFF.

*PARA ESTA POBLACIÓN (DE LA RM Y DE ZONA RURAL) REALIZAMOS TABLA CRUZADA DE LA VARIABLE S26B_4 Y EL NIVEL SOCIOECONOMICO (NSE)*

CROSSTABS
  /TABLES=s26b_4 BY nse
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT COLUMN 
  /COUNT ROUND CELL
  /BARCHART.
OUTPUT MODIFY
  /SELECT TABLES
  /IF COMMANDS=["Crosstabs(LAST)"] SUBTYPES=["Crosstabulation"]
  /TABLE PIVOT=[R1,C1].
OUTPUT MODIFY
  /SELECT TABLES
  /IF COMMANDS=["Crosstabs(LAST)"] SUBTYPES=["Crosstabulation"]
  /TABLECELLS SELECT=[PERCENT] APPLYTO=COLUMNHEADER REPLACE="%"
  /TABLECELLS SELECT=[COUNT] APPLYTO=COLUMNHEADER REPLACE="N".

*QUITAMOS EL FILTRO DE ZONA Y AHORA TRABAJAMOS SOLO CON PERSONAS DE LA PRIMERA REGION*

USE ALL.
COMPUTE filter_$=(region = 1).
VARIABLE LABELS filter_$ 'region = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.
_SLINE OFF.

*GENERAMOS PARA ESTA POBLACION UN GRAFICO DE CAJA Y BIGOTES PARA LA VARIABLE Y1 COMPARADO POR AREA*

EXAMINE VARIABLES=y1 BY area
  /PLOT BOXPLOT STEMLEAF
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

*ESTABLECEMOS UNA COMPARACIÓN FORMAL ENTRE LOS DATOS SEGÚN EL SEXO DE LAS PERSONAS*

SORT CASES  BY sexo.
SPLIT FILE LAYERED BY sexo.

*GENERAMOS TABLA DE MEDIDAS DE TENDENCIA CENTRAL PARA LA VARIABLE Y1* 

FREQUENCIES VARIABLES=y1
  /FORMAT=NOTABLE
  /STATISTICS=MEAN MEDIAN MODE SUM
  /ORDER=ANALYSIS.

*QUITAMOS LA COMPARACIÓN FORMAL*

SPLIT FILE OFF.

*CAMBIAMOS POR ULTIMA VEZ EL FILTRO DE REGION ESTABLECIENDO AHORA LA QUINTA*

USE ALL.
COMPUTE filter_$=(region = 5).
VARIABLE LABELS filter_$ 'region = 5 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.
_SLINE OFF.

*PARA CALCULAR INDICE DE FEMINIZACIÓN GENERAMOS TABLA DE FRECUENCIA DE LA VARIABLE SEXO*

FREQUENCIES VARIABLES=sexo
  /STATISTICS=MEAN MEDIAN MODE SUM
  /ORDER=ANALYSIS.

*PARA CALCULAR INDICE DE ENVEJECIMIENTO RECODIFICAMOS LA VARIABLE EDAD EN TRES TRAMOS, NO OLVIDEMOS ETIQUETAR LOS DATOS*

RECODE edad (0 thru 14=1) (15 thru 59=2) (60 thru Highest=3) INTO tramos_edad.
VARIABLE LABELS  tramos_edad 'Tramos de edad'.
EXECUTE.

*PARA CALCULAR INDICE DE ENVEJECIMIENTO GENERAMOS TABLA DE FRECUENCIA DE LA VARIABLE TRAMOS DE EDAD*

FREQUENCIES VARIABLES=tramos_edad
  /STATISTICS=MEAN MEDIAN MODE SUM
  /ORDER=ANALYSIS.

*RECUERDEN GUARDAR SU SINTAXIS*
